***************************************
* This Stata dofile is written to accompany the paper:
* Andrew Leigh & Tirta Susilo, 
* "Is Voting Skin-Deep? Estimating the Effect of Candidate Ballot Photographs on Election Outcomes", 
* Journal of Economic Psychology, 2009 
* Feel free to use or adapt it, so long as you cite that paper.
* Questions to andrew_leigh@ksg02.harvard.edu
***************************************

cd "C:\Users\Andrew\My publications\Aust - beautiful politicians etc\"
use nt_election_2005.dta, clear
set more off
ren abo ab
la var ab "Share Indigenous"
for any ove na ab: replace X=X/100 \ replace X=X[_n-1] if X==.
ren gender female
la var female "Female"
replace party="IND" if party=="No Party"
drop if candidate=="Highway" & electorate=="Nightcliff"
gen skin_original=skin
sum im24 if39 nif24 nim40
pwcorr im24 if39 nif24 nim40, sig
pwcorr im24 if39 nif24 nim40 if skin<=3, sig
pwcorr im24 if39 nif24 nim40 if skin>=4, sig
for any im24 if39 nif24 nim40: egen temp=std(X) \ replace X=temp \ drop temp
gen beauty=(im24+if39+nif24+nim40)/4
for var im24 if39 nif24 nim40 beauty: pwcorr X skin, sig
for any beauty skin: egen temp=std(X) \ replace X=temp \ drop temp
for any beauty skin: gen X_ab=X*ab

* Summary statistics
for any ALP CLP Greens IND: gen party_X=1 if party=="X" \ recode party_X .=0
sum voteshare incumbentcandidate party_* female beauty skin_original skin ab, sep(0)

xi: reg voteshare beauty incumbentcandidate female ,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("")
xi: reg voteshare beauty incumbentcandidate female i.party,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("")
xi: reg voteshare skin skin_ab ab incumbentcandidate female ,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("")
xi: reg voteshare skin skin_ab incumbentcandidate female ab  i.party,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("")
xi: reg voteshare beauty skin skin_ab incumbentcandidate female ab  i.party,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("")
xi: reg voteshare beauty beauty_ab skin skin_ab incumbentcandidate female ab  i.party,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("")

* Skin color differences
bysort electorate: egen skin_mean=mean(skin)
gen skin_diff=skin-skin_mean
gen skin_diff_ab=skin_diff*ab
xi: reg voteshare skin_diff skin_diff_ab ab incumbentcandidate female ,r cl(electorate)
xi: reg voteshare skin_diff skin_diff_ab ab incumbentcandidate female i.party,r cl(electorate)

* Dichotomous coding
gen skin_dummy=skin_original
recode skin_dummy 0/2=0 3/16=1
gen skin_dummy_ab=skin_dummy*ab
xi: reg voteshare skin_dummy skin_dummy_ab ab incumbentcandidate female ,r cl(electorate)
xi: reg voteshare skin_dummy skin_dummy_ab incumbentcandidate female ab  i.party,r cl(electorate)

* Robustness check - throwing out 40 yo NIM ratings
gen beauty2=(im24+if39+nif24)/3
for any beauty2: egen temp=std(X) \ replace X=temp \ drop temp
for any beauty2: gen X_ab=X*ab
xi: reg voteshare beauty2 incumbentcandidate female ,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Excl NIM40")
xi: reg voteshare beauty2 incumbentcandidate female i.party,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Excl NIM40")
xi: reg voteshare beauty2 skin skin_ab incumbentcandidate female ab  i.party,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Excl NIM40")
xi: reg voteshare beauty2 beauty2_ab skin skin_ab incumbentcandidate female ab  i.party,r cl(electorate)
outreg using results_nt.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Excl NIM40")


* Graphs
*la var skin "Darker skin ->"
*la var skin_original "Darker skin ->"
*la var beauty "Better looking ->"
la var skin "Darker skin     "
la var skin_original "Darker skin     "
la var beauty "Better looking     "


set scheme s1mono
for num 0/1: reg voteshare beauty if incumbentc==X
tw scatter voteshare beauty if incumbentc==0  || lfit voteshare beauty if incumbentc==0, ti("Challengers") legend(off) name(_1,replace) nodraw note("Vote share = 0.227 + 0.065 * Beauty (t=3.3)" "N=57")
tw scatter voteshare beauty if incumbentc==1 || lfit voteshare beauty if incumbentc==1, ti("Incumbents") legend(off)  name(_2,replace) nodraw note("Vote share = 0.559 + 0.014 * Beauty (t=0.5)" "N=22")
gr combine _1 _2 ,xcommon ti("Figure 3: Candidate Beauty and Vote Share" "(vote share on vertical axis)") 
*graph export leigh_susilo_fig3.eps, replace
*graph export leigh_susilo_fig3.wmf, replace

set scheme s1mono
for num 0/1: reg voteshare skin_original if incumbentc==X
tw scatter voteshare skin_original if incumbentc==0 || lfit voteshare skin_original if incumbentc==0, ti("Challengers") mlabel(candidate) legend(off) name(_1,replace) nodraw note("Vote share = 0.218 + 0.001 * SkinColor (t=0.1)" "N=57")
tw scatter voteshare skin_original if incumbentc==1 || lfit voteshare skin_original if incumbentc==1, ti("Incumbents") mlabel(candidate) legend(off)  name(_2,replace) nodraw note("Vote share = 0.534 + 0.008 * SkinColor (t=0.8)" "N=22")
gr combine _1 _2 ,xcommon ti("Figure XXX: Candidate Skin Color and Vote Share" "(vote share on vertical axis)") 


set scheme s1mono
for num 0/1: reg voteshare skin_original if ab<.13 & incumbentc==X
for num 0/1: reg voteshare skin_original if ab>.13 & incumbentc==X
tw scatter voteshare skin_original if ab<.13 & incumbentc==0 || lfit voteshare skin_original if ab<.13 & incumbentc==0, subti("Challengers, Non-Indigenous Electorates") mlabel(candidate) legend(off) name(_1,replace) nodraw note("Vote share = 0.399 - 0.057 * SkinColor (t=-3.1)" "N=27")
tw scatter voteshare skin_original if ab<.13 & incumbentc==1 || lfit voteshare skin_original if ab<.13 & incumbentc==1, subti("Incumbents, Non-Indigenous Electorates") mlabel(candidate) legend(off)  name(_2,replace) nodraw note("Vote share = 0.604 - 0.017 * SkinColor (t=-1.0)" "N=11")
tw scatter voteshare skin_original if ab>.13 & incumbentc==0 || lfit voteshare skin_original if ab>.13 & incumbentc==0, subti("Challengers, Indigenous Electorates") mlabel(candidate) legend(off)  name(_3,replace) nodraw note("Vote share = 0.160 + 0.018 * SkinColor (t=1.4)" "N=30")
tw scatter voteshare skin_original if ab>.13 & incumbentc==1 || lfit voteshare skin_original if ab>.13 & incumbentc==1, subti("Incumbents, Indigenous Electorates") mlabel(candidate) legend(off)  name(_4,replace) nodraw note("Vote share = 0.510 + 0.014 * SkinColor (t=0.9)" "N=11")
gr combine _1 _2 _3 _4,xcommon ti("Figure 4: Candidate Skin Color and Vote Share" "(vote share on vertical axis)") note("Indigenous electorates are defined as those with more than 13% Indigenous population")
*graph export leigh_susilo_fig4.eps, replace
*graph export leigh_susilo_fig4.wmf, replace

set scheme s1mono
tw scatter voteshare beauty if ab<.13 & incumbentc==0 || lfit voteshare beauty if ab<.13 & incumbentc==0, ti("Challengers, non-Indigenous electorates") mlabel(candidate) legend(off) name(_1,replace) nodraw
tw scatter voteshare beauty if ab<.13 & incumbentc==1 || lfit voteshare beauty if ab<.13 & incumbentc==1, ti("Incumbents, non-Indigenous electorates") mlabel(candidate) legend(off)  name(_2,replace) nodraw
tw scatter voteshare beauty if ab>.13 & incumbentc==0 || lfit voteshare beauty if ab>.13 & incumbentc==0, ti("Challengers, Indigenous electorates") mlabel(candidate) legend(off)  name(_3,replace) nodraw
tw scatter voteshare beauty if ab>.13 & incumbentc==1 || lfit voteshare beauty if ab>.13 & incumbentc==1, ti("Incumbents, Indigenous electorates") mlabel(candidate) legend(off)  name(_4,replace) nodraw
gr combine _1 _2 _3 _4,xcommon ti("Candidate Beauty and Vote Share" "(vote share on vertical axis)") note("Indigenous electorates are defined as those with more than 13% Indigenous population")


